﻿<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:GUIRes="urn:GUIRes" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
  <!-- Copyright @2015 Motorola Solutions, Inc.  All rights reserved -->

  <!-- REPORT INFORMATION 
  MODIFY TITLE_ID AND USER_DEFINED TO CHANGE TITLE  
  <REPORT_INFO>
    <TITLE>CUSTOMER_HANDOUT</TITLE>
    <USER_TITLE></USER_TITLE>
    <DEALER_INFO>YES</DEALER_INFO>
  </REPORT_INFO>
  END REPORT INFORMATION !-->

  <!-- PARAMETERS - DO NOT MODIFY -->
  <xsl:import href="APXCommon.xsl"/>
  <xsl:param name="sResXml"/>
  <xsl:param name="sImageDir"/>

  <xsl:variable name="report_res" select="msxsl:node-set($sResXml)"/>
  <xsl:variable name="alias_res" select="$report_res//ALIASES"/>
  <xsl:variable name="image_res" select="$report_res//IMAGES"/>
  <xsl:variable name="model_res" select="$report_res//MODELS"/>

  <xsl:variable name="CONFIG" select="/"/>
  <xsl:variable name="RADIO_INFO_Type" select= "//RADIO_INFO/SET"/>

  <xsl:variable name="model_type" select='$model_res/MODEL[@type = $RADIO_INFO_Type/RadInfoLabtoolProductModelIdentifier_A37178]'/>
  <xsl:variable name="model_number" select="//RadInfoGeneralModelNumber_A8539"/>
  <xsl:variable name="product_name" select="$model_type/@name"/>
  <xsl:template name="ProductImage">
        <xsl:choose>
        <xsl:when test="$report_res//MODELS/MODEL[@type = $RADIO_INFO_Type/RadInfoLabtoolProductModelIdentifier_A37178]/IMG[@model=$model_number] != ''"  >
        <xsl:variable name="imageSrc" select="$report_res//MODELS/MODEL[@type = $RADIO_INFO_Type/RadInfoLabtoolProductModelIdentifier_A37178]/IMG[@model=$model_number]"/>
          <xsl:choose>
            <xsl:when test="$imageSrc/@width != '' and $imageSrc/@height !=''">
              <img src="{concat($sImageDir, $imageSrc)}" width="{$imageSrc/@width}" height="{$imageSrc/@height}"/>
            </xsl:when>
            <xsl:when test="$imageSrc/@width != ''">
              <img src="{concat($sImageDir, $imageSrc)}" width="{$imageSrc/@width}"/>
            </xsl:when>
            <xsl:when test="$imageSrc/@height !=''">
              <img src="{concat($sImageDir, $imageSrc)}" height="{$imageSrc/@height}"/>
            </xsl:when>
            <xsl:otherwise>
              <img src="{concat($sImageDir, $imageSrc)}"/>
            </xsl:otherwise>
          </xsl:choose>     
        </xsl:when>
        <xsl:when test="$report_res//MODELS/MODEL[@type = $RADIO_INFO_Type/RadInfoLabtoolProductModelIdentifier_A37178]/IMG[@model='default'] != ''"  >
          <xsl:variable name="imageSrc" select="$report_res//MODELS/MODEL[@type = $RADIO_INFO_Type/RadInfoLabtoolProductModelIdentifier_A37178]/IMG[@model='default']"/>
          <xsl:choose>
            <xsl:when test="$imageSrc/@width != '' and $imageSrc/@height !=''">
              <img src="{concat($sImageDir, $imageSrc)}" width="{$imageSrc/@width}" height="{$imageSrc/@height}"/>
            </xsl:when>
            <xsl:when test="$imageSrc/@width != ''">
              <img src="{concat($sImageDir, $imageSrc)}" width="{$imageSrc/@width}"/> 
            </xsl:when>
            <xsl:when test="$imageSrc/@height !=''">
              <img src="{concat($sImageDir, $imageSrc)}" height="{$imageSrc/@height}"/>
            </xsl:when>
            <xsl:otherwise>
              <img src="{concat($sImageDir, $imageSrc)}"/>
            </xsl:otherwise>
          </xsl:choose>                  
        </xsl:when>        
      </xsl:choose>
    </xsl:template>  
  <xsl:variable name="persperpage">5</xsl:variable>

  <xsl:variable name="countCh" select="count(//ZONES/SET/CHANNEL/SET)"/>
  <xsl:variable name="numpageCh" select="ceiling($countCh div $persperpage)"/>

  <xsl:variable name="pagestart" select="number(1)"/>
  <xsl:variable name="increment" select="number(1)"/>
  <xsl:variable name="trunkingEnabled">
    <xsl:choose>
      <xsl:when test="count(//ASTRO25TRUNKINGSYSTEM/SET) > 0 or count(//COMMONTYPEIITRUNKINGSYSTEM/SET) > 0">true</xsl:when>      
      <xsl:otherwise>false</xsl:otherwise>      
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="isWorldWidePro">
    <xsl:call-template name="IS_WORLD_WIDE_PRO"/>
  </xsl:variable>
  <xsl:variable name="is3000Model">
    <xsl:call-template name="IS_3000_MODEL"/>    
  </xsl:variable>

  <xsl:output omit-xml-declaration="yes"/>

  <xsl:template match="/">
    <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html&gt;</xsl:text>
    <html>
      <head>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
        <title>
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name ="lookup">ID_MODELNUMBER</xsl:with-param>
          </xsl:call-template>: <xsl:value-of select="//RadInfoGeneralModelNumber_A8539"/>
          <xsl:text> </xsl:text><xsl:call-template name="GUI_LOOK">
            <xsl:with-param name ="lookup">ID_SERIALNUMBER</xsl:with-param>
          </xsl:call-template>: <xsl:value-of select="//RadInfoGeneralSerialNumber_A9122"/>
        </title>
        <xsl:text disable-output-escaping="yes">
               &lt;style>
                  &lt;!--
                  html {font-family: arial unicode ms; sans-serif}
                  ul.attributes {margin-left: 0.3cm; text-align left; list-style: none; font-size: 9pt}
                  ul {list-style-type: none}
                  th {font-weight: bold; font-size: 9pt; background: none; color: #4886C1; text-align:left}
                  th.channel {text-align: left; font-size: 15; font-weight: bold; color: #4886C1;padding:5px}
                  td {vertical-align: top; font-size: 9pt;padding-left:5px;padding-right:5px;}
                    .em_head {text-align: left; font-size: 12; font-weight: bold; color: #4886C1}
                    .em_width {vertical-align: center; text-align: left;font-size: 10; font-weight: bold; width: 150}
                    .em_std {vertical-align: center; text-align: left;font-size: 10; font-weight: bold;padding-left:5px;padding-right:5px;}
                  td.bottom {vertical-align: bottom; font-size: 9pt}
                  td.button {text-align: center;vertical-align: middle; font-size: 9pt}
                  td.sep {border-style:none none solid none; border-width:1px;border-collapse:collapse;	border-color:white white #e0e0e0 white;border-collapse:collapse;font-size:9pt;}	
                  td.sepcn {border-style:none none solid none; border-width:5px;border-collapse:collapse;	border-color:white white #e0e0e0 white;border-collapse:collapse;font-size:9pt; vertical-align: middle;}			
                  td.led {border-style:solid; border-width:5px;text-align: center;border-color:white white #e0e0e0 white; font-weight: bold;font-size:10pt; color: #4886C1;}					 
                  td.bold {vertical-align: center; font-size: 9pt; font-weight: bold}
                  td.pic {vertical-align: top; font-size: 9pt; text-align: center}
                  td.num {border-style:none none solid none; border-width:5px;border-collapse:collapse;	border-color:white white #e0e0e0 white; padding:5px;font-size:9pt;width:30px}
                  h1 {text-align: center; font-size:26; color: #4886C1;}
                  h3 {text-align:left; font-size:20; color: #4886C1;}
                  h4 {text-align: left; font-size: 9pt}
                  td.serialnum {text-align: left; font-size: 9pt}
                  td.modelnum {text-align: right; font-size: 9pt}
                  td.cn {vertical-align: top; text-align: center;font-size: 9pt; font-weight: bold}
                  td.menu { vertical-align: middle; font-size: 12pt; font-weight: bold; border-style:none none solid none; border-width:5px;border-collapse:collapse;	border-color:white white #e0e0e0 white; padding:5px;border-collapse:collapse;}
                  td.submenu{vertical-align: top; text-align: left; font-size: 9pt;border-style:none none solid none; border-width:5px;border-collapse:collapse; border-color:white white #e0e0e0 white; padding:5px;border-collapse:collapse;}
                  td.header {font-weight: bold; font-size: 9pt; font-weight:bold; text-align: center; color: #4886C1}
                  td.headerleft {font-weight: bold; font-size: 9pt; text-align: left; color:#4886C1; background: none;}
                  td.headercenter {font-weight: bold; font-size: 9pt; text-align: center; color:#4886C1; background: none;}
                  td.fixed { vertical-align: middle; font-size: 9pt}
                  td.top { text-align: right; font-size: 9pt; border-top: solid #4886C1}
                  td.led { height: 25;}
                  .dealer{width: 213px; overflow: hidden;}
                  .em_std {vertical-align: center; text-align: left;font-size: 10; font-weight: bold;padding-left:5px;padding-right:5px;}
                  .em_blu {vertical-align: left; text-align: left;font-size: 10; font-weight: bold;padding-left:5px;padding-right:5px;color: #4886C1}
                  h3.breakBefore {page-break-before: always}
                  th.em1 {text-align: left; font-size: 14pt; background: none; font-weight: bold; color: #4886C1; border-style:none none solid none; border-width:5px;border-collapse:collapse;	border-color:white white #e0e0e0 white; padding:5px;border-collapse:collapse;}
                  img.num {width: 25px;}
                  img.std {width: 100%;}
                  img.rep {width: 640px;}
                  img.narrow {width: 350px;}
                  img.vert {width: 300px;}
                  table{border-collapse:collapse}
                  .white{border-style:solid;border-width:10px;border-collapse:collapse;border-color:#ffffff;}
                  .stdwhite {border-style:solid;border-width:10px;border-collapse:collapse;border-color:#ffffff;width:100%;}
                  .nocollapse{border-style:solid;border-width:10px;border-color:#ffffff;}
                  .std {width:100%;}
                  .std_rep {width:640px;}
                  .gimgsize {width:320px;}
                  .lblsize {width:45px;vertical-align: top; font-size: 9pt}
                  .tab {width:20px}
                  -->
               &lt;/style>
        </xsl:text>
      </head>
      <body>
        <xsl:variable name='imgheader' select="$image_res/IMAGE[@id='APX_HEADER']"/>
        <img class="std" src ="{concat($sImageDir, $imgheader)}"/>
        <h1>
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">Radio_Handout</xsl:with-param>
          </xsl:call-template>
          <xsl:text> - </xsl:text>
          <xsl:value-of select="$product_name"/>       
        </h1>
        <table class="stdwhite">
          <tr>
            <xsl:text disable-output-escaping = "yes">
              &lt;td> &amp;nbsp &lt;/td>
            </xsl:text>
          </tr>
          <tr>
            <td class="top" colspan="2">
              <table class="white" width="100%">
                <tr>
                  <td class="fixed" colspan="2">
                    <xsl:call-template name="GENERAL_RADIO_INFO"/>
                  </td>
                </tr>
                <tr>
                  <td colspan="2">
                    <table width="100%">
                      <tr>
                        <xsl:choose>
                          <xsl:when test="$trunkingEnabled = 'true'">
                            <th class="em1" colspan="4">
                              <xsl:call-template name="GUI_LOOK">
                                <xsl:with-param name="lookup">Buttons_and_Controls</xsl:with-param>
                              </xsl:call-template>
                            </th>
                          </xsl:when>
                          <xsl:otherwise>
                            <th class="em1" colspan="3">
                              <xsl:call-template name="GUI_LOOK">
                                <xsl:with-param name="lookup">Buttons_and_Controls</xsl:with-param>
                              </xsl:call-template>
                            </th>
                          </xsl:otherwise>
                        </xsl:choose>                                                               
                      </tr>
                      <tr>
                        <td class="sep">
                          <xsl:call-template name="GUI_LOOK">
                            <xsl:with-param name="lookup">Index_Id</xsl:with-param>
                          </xsl:call-template>
                        </td>
                        <td class="sep">
                          <xsl:call-template name="GUI_LOOK">
                            <xsl:with-param name="lookup">Description_Id</xsl:with-param>
                          </xsl:call-template>
                        </td>
                        <td class="sep">
                          <xsl:call-template name="GUI_LOOK">
                            <xsl:with-param name="lookup">Conventional_Id</xsl:with-param>
                          </xsl:call-template>
                        </td>
                        <xsl:if test="$trunkingEnabled = 'true'">
                          <td class="sep">
                            <xsl:call-template name="GUI_LOOK">
                              <xsl:with-param name="lookup">Trunking_ID</xsl:with-param>
                            </xsl:call-template>
                          </td>
                        </xsl:if>
                      </tr>
                      <xsl:choose>
                      <xsl:when test="$isWorldWidePro = 'true'">
                        <xsl:call-template name="MFK_BUTTONS_PORTABLE"/>              
                      </xsl:when>
                      <xsl:when test="$is3000Model = 'true'">
                        <xsl:call-template name="POWER_FOR_3000"/>                      
                      </xsl:when>
                        <xsl:otherwise>
                          <xsl:call-template name="POWER_VOLUME"/>                          
                          <xsl:call-template name="TWO_POSITION_CONCENTRIC"/>
                          <xsl:call-template name="THREE_POSITION_TOGGLE"/>
                          <xsl:call-template name="ROTARY_CONTROL"/>                          
                        </xsl:otherwise>
                      </xsl:choose>
                      <xsl:call-template name="PORTABLE_BUTTONS"/>
                      <xsl:call-template name="DATA_BUTTON"/>                      
                      <xsl:call-template name="KEYPAD_BUTTONS">
                        <xsl:with-param name="keypadButtons" select="//PORTABLEKEYPADBUTTON/SET"/>
                      </xsl:call-template>
                      <xsl:call-template name="SIDE_ARROW_BUTTONS"/>
                      <xsl:if test="$is3000Model = 'true'">
                        <xsl:call-template name="SMART_KEY_FOB_3000"/>
                      </xsl:if>
                
                      
                  
                    </table>
                  </td>
                </tr>
              </table>
            </td>
            <td class="fixed">
              <xsl:call-template name="ProductImage"/>
            </td>
          </tr>
        </table>
        <DIV style="page-break-before:always">
          <img class="std" src ="{concat($sImageDir, $imgheader)}"/>
          <table class="stdwhite">
            <tr>
              <td colspan="5">
                <xsl:text disable-output-escaping="yes">&amp;nbsp</xsl:text>
              </td>
            </tr>
            <tr>
              <th colspan="5" class="em1">
                <xsl:call-template name="GUI_LOOK">
                  <xsl:with-param name ="lookup">Zones_and_Channels</xsl:with-param>
                </xsl:call-template>
              </th>
            </tr>
            <xsl:if test="$countCh &gt; 0">
              <xsl:call-template name="channelloop">
                <xsl:with-param name="counter" select="$pagestart"/>
                <xsl:with-param name="numpages" select="$numpageCh"/>
              </xsl:call-template>
            </xsl:if>
          </table>
        </DIV>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="GENERAL_RADIO_INFO">
    <table width="100%">
      <tr>
        <td class="sep">
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">ID_MODELNUMBER</xsl:with-param>
          </xsl:call-template>
        </td>
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//RadInfoGeneralModelNumber_A8539" />
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td class="sep">
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">ID_SERIALNUMBER</xsl:with-param>
          </xsl:call-template>
        </td>
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//RadInfoGeneralSerialNumber_A9122" />
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td class="sep">
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">ID_FLASHCODE</xsl:with-param>
          </xsl:call-template>
        </td>
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//RadInfoFLASHportFLASHcode_A8132" />
          </xsl:call-template>
        </td>
      </tr>
    </table>
  
  </xsl:template>
  
    <xsl:template name="MFK_BUTTONS_PORTABLE">
    <xsl:variable name="mfk_button_portable" select="//SWITCHESMFKASSIGNMENTCONTROL/SET"/>
    <tr>
      <td class="sep" rowspan="{count($mfk_button_portable)+2}">
        <xsl:value-of select="GUIRes:IncrementRowCount()"/>
      </td>
      <xsl:choose>
        <xsl:when test="$trunkingEnabled = 'true'">
          <th colspan="3">
            <xsl:call-template name="GUI_LOOK">
              <xsl:with-param name="lookup">ID_MULTIFUNCTIONKNOB</xsl:with-param>
            </xsl:call-template>
          </th>
        </xsl:when>
        <xsl:otherwise>
          <th colspan="2">
            <xsl:call-template name="GUI_LOOK">
              <xsl:with-param name="lookup">ID_MULTIFUNCTIONKNOB</xsl:with-param>
            </xsl:call-template>
          </th>
        </xsl:otherwise>      
      </xsl:choose>   
    </tr>
    <tr>
      <td/>
      <td>
        <xsl:call-template name="GUI_LOOK">
          <xsl:with-param name="lookup">Power_Id</xsl:with-param>
        </xsl:call-template>
      </td>
      <xsl:if test="$trunkingEnabled = 'true'">
        <td>
        <xsl:call-template name="GUI_LOOK">
          <xsl:with-param name="lookup">Power_Id</xsl:with-param>
        </xsl:call-template>
        </td>
      </xsl:if>
    </tr>
    <xsl:for-each select="$mfk_button_portable">
      <tr>
        <xsl:choose>
          <xsl:when test="position() = last()">
            <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="./SwitchMFKAssignmentControlName_A38529"/>
        </xsl:call-template>
        <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        <xsl:choose>
          <xsl:when test="position() = last()">
            <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="./RadErgoControlSwitchsMFKFeatureAssignment_A38514"/>
        </xsl:call-template>
        <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        <xsl:if test="$trunkingEnabled = 'true'">
          <xsl:choose>
            <xsl:when test="position() = last()">
              <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="./RadErgoControlSwitchsMFKFeatureAssignment_A38514"/>
          </xsl:call-template>
          <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        </xsl:if>
      </tr>
    </xsl:for-each>
  </xsl:template>
  
    <xsl:template name="POWER_FOR_3000">
      <tr>
        <td class="sep">
          <xsl:value-of select="GUIRes:IncrementRowCount()"/>
        </td>
        <td class="sep"/>
        <td class="sep">
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">Power_Id</xsl:with-param>
          </xsl:call-template>
        </td>
        <xsl:if test="$trunkingEnabled = 'true'">
          <td class="sep">
            <xsl:call-template name="GUI_LOOK">
              <xsl:with-param name="lookup">Power_Id</xsl:with-param>
            </xsl:call-template>
          </td>
        </xsl:if>
      </tr>
  </xsl:template>
  
  <xsl:template name="POWER_VOLUME">
    <tr>
      <td class="sep">
        <xsl:value-of select="GUIRes:IncrementRowCount()"/>
      </td>
      <td class="sep"/>
      <td class="sep">
        <xsl:call-template name="GUI_LOOK">
          <xsl:with-param name="lookup">Power_Volume</xsl:with-param>
        </xsl:call-template>
      </td>
      <xsl:if test="$trunkingEnabled = 'true'">
        <td class="sep">
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">Power_Volume</xsl:with-param>
          </xsl:call-template>
        </td>
      </xsl:if>
    </tr>
  </xsl:template>  
  

  <xsl:template name="TWO_POSITION_CONCENTRIC">
    <xsl:if test="count(//SwitchConventionalSwitchesPosition1_A7734) > 0 or count(//SwitchTrunkingSwitchesPosition1_A9466) > 0 or 
      count(//SwitchConventionalSwitchesPosition2_A7735) > 0 or count(//SwitchTrunkingSwitchesPosition2_A9467) > 0">
      <tr>
        <td class="sep" rowspan="3">
          <xsl:value-of select="GUIRes:IncrementRowCount()"/>
        </td>
        <xsl:choose>
          <xsl:when test="$trunkingEnabled = 'true'">
            <th colspan="3">
              <xsl:call-template name="GUI_LOOK">
                <xsl:with-param name="lookup">Two_Position_Concentric</xsl:with-param>
              </xsl:call-template>
            </th>
          </xsl:when>
          <xsl:otherwise>
            <th colspan="2">
              <xsl:call-template name="GUI_LOOK">
                <xsl:with-param name="lookup">Two_Position_Concentric</xsl:with-param>
              </xsl:call-template>
            </th>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">Position_A</xsl:with-param>
          </xsl:call-template>
        </td>
        <td>
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//SwitchConventionalSwitchesPosition1_A7734"/>
          </xsl:call-template>
        </td>
        <xsl:if test="$trunkingEnabled = 'true'">
          <td>
            <xsl:call-template name="GUI_RES">
              <xsl:with-param name="cp_node" select="//SwitchTrunkingSwitchesPosition1_A9466"/>
            </xsl:call-template>
          </td>
        </xsl:if>
      </tr>
      <tr>
        <td class="sep">
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">Position_B</xsl:with-param>
          </xsl:call-template>
        </td>
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//SwitchConventionalSwitchesPosition2_A7735"/>
          </xsl:call-template>
        </td>
        <xsl:if test="$trunkingEnabled = 'true'">
          <td class="sep">
            <xsl:call-template name="GUI_RES">
              <xsl:with-param name="cp_node" select="//SwitchTrunkingSwitchesPosition2_A9467"/>
            </xsl:call-template>
          </td>
        </xsl:if>
      </tr>
    </xsl:if>
  </xsl:template>

  <xsl:template name="THREE_POSITION_TOGGLE">
    <xsl:if test="count(//SwitchConventionalSwitchesPosition3_A7737) > 0 or count(//SwitchTrunkingSwitchesPosition3_A9468) > 0 or 
      count(//SwitchConventionalSwitchesPosition4_A21530) > 0 or count(//SwitchTrunkingSwitchesPosition4_A21534) > 0 or
      count(//SwitchConventionalSwitchesPosition5_A21531) > 0 or count(//SwitchTrunkingSwitchesPosition5_A21535) > 0">
      <tr>
        <td class="sep" rowspan="4">
          <xsl:value-of select="GUIRes:IncrementRowCount()"/>
        </td>
        <xsl:choose>
          <xsl:when test="$trunkingEnabled = 'true'">
            <th colspan="3">
              <xsl:call-template name="GUI_LOOK">
                <xsl:with-param name="lookup">Three_Position_Toggle</xsl:with-param>
              </xsl:call-template>
            </th>
          </xsl:when>
          <xsl:otherwise>
            <th colspan="2">
              <xsl:call-template name="GUI_LOOK">
                <xsl:with-param name="lookup">Three_Position_Toggle</xsl:with-param>
              </xsl:call-template>
            </th>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">Position_A</xsl:with-param>
          </xsl:call-template>
        </td>
        <td>
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//SwitchConventionalSwitchesPosition3_A7737"/>
          </xsl:call-template>
        </td>
        <td>
          <xsl:if test="$trunkingEnabled = 'true'">
            <xsl:call-template name="GUI_RES">
              <xsl:with-param name="cp_node" select="//SwitchTrunkingSwitchesPosition3_A9468"/>
            </xsl:call-template>
          </xsl:if>
        </td>
      </tr>
      <tr>
        <td>
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">Position_B</xsl:with-param>
          </xsl:call-template>
        </td>
        <td>
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//SwitchConventionalSwitchesPosition4_A21530"/>
          </xsl:call-template>
        </td>
        <xsl:if test="$trunkingEnabled = 'true'">
          <td>
            <xsl:call-template name="GUI_RES">
              <xsl:with-param name="cp_node" select="//SwitchTrunkingSwitchesPosition4_A21534"/>
            </xsl:call-template>
          </td>
        </xsl:if>
      </tr>
      <tr>
        <td class="sep">
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">Position_C</xsl:with-param>
          </xsl:call-template>
        </td>
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//SwitchConventionalSwitchesPosition5_A21531"/>
          </xsl:call-template>
        </td>
        <xsl:if test="$trunkingEnabled = 'true'">
          <td class="sep">
            <xsl:call-template name="GUI_RES">
              <xsl:with-param name="cp_node" select="//SwitchTrunkingSwitchesPosition5_A21535"/>
            </xsl:call-template>
          </td>
        </xsl:if>
      </tr>
    </xsl:if>
  </xsl:template>

  <xsl:template name="ROTARY_CONTROL">
    <tr>
      <td class="sep">
        <xsl:value-of select="GUIRes:IncrementRowCount()"/>
        </td>
        <td class="sep">
        <xsl:call-template name ="GUI_LOOK">
          <xsl:with-param name="lookup">ID_ROTARYCONTROL</xsl:with-param>
        </xsl:call-template>
        </td>
        <td class="sep">
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="//SwitchGeneralRotaryControl_A8984"/>
        </xsl:call-template>
        </td>
        <xsl:if test="$trunkingEnabled = 'true'">
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//SwitchGeneralRotaryControl_A8984"/>
          </xsl:call-template>
        </td>
      </xsl:if>
    </tr>    
  </xsl:template>

  <xsl:template name="DATA_BUTTON">
    <xsl:if test="count(//BtnConventionalButtonDatatButtonFeature_A22610) > 0 or count(//BtnTrunkingButtonDatatButtonFeature_A22608) > 0">
      <tr>
        <td class="sep">
          <xsl:value-of select="GUIRes:IncrementRowCount()"/>
        </td>
        <td class="sep">
          <xsl:call-template name ="GUI_LOOK">
            <xsl:with-param name="lookup">ID_DATABUTTON_1</xsl:with-param>
          </xsl:call-template>
        </td>
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//BtnConventionalButtonDatatButtonFeature_A22610"/>
          </xsl:call-template>
        </td>
        <xsl:if test="$trunkingEnabled = 'true'">
          <td class="sep">
            <xsl:call-template name="GUI_RES">
              <xsl:with-param name="cp_node" select="//BtnTrunkingButtonDatatButtonFeature_A22608"/>
            </xsl:call-template>
          </td>
        </xsl:if>
      </tr>
    </xsl:if>
  </xsl:template>

  <xsl:template name="SIDE_ARROW_BUTTONS">
    <xsl:variable name="side_arrow_button" select="//PORTABLESIDEUPDOWNARROWBUTTON/SET"/>
    <xsl:if test="count($side_arrow_button) > 0">
      <tr>
        <td class="sep" rowspan="3">
          <xsl:value-of select="GUIRes:IncrementRowCount()"/>
        </td>
        <xsl:choose>
          <xsl:when test="$trunkingEnabled = 'true'">
            <th colspan="3">
              <xsl:call-template name="GUI_LOOK">
                <xsl:with-param name="lookup">ID_SIDEARROWBUTTONS</xsl:with-param>
              </xsl:call-template>
            </th>
          </xsl:when>
          <xsl:otherwise>
            <th colspan="2">
              <xsl:call-template name="GUI_LOOK">
                <xsl:with-param name="lookup">ID_SIDEARROWBUTTONS</xsl:with-param>
              </xsl:call-template>
            </th>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
    </xsl:if>
    <xsl:for-each select="$side_arrow_button">
      <tr>
        <xsl:choose>
          <xsl:when test="position() = last()">
            <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="./BtnSideArrowButtonName_A41567"/>
        </xsl:call-template>
        <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        <xsl:choose>
          <xsl:when test="position() = last()">
            <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="./BtnSideUpDownArrowButtonPrimaryFunction_A41568"/>
        </xsl:call-template> | 
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="./BtnSideUpDownArrowButtonSecondaryFunction_A41592"/>
        </xsl:call-template>        
        <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        <xsl:if test="$trunkingEnabled = 'true'">
          <xsl:choose>
            <xsl:when test="position() = last()">
              <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="./BtnSideUpDownArrowButtonPrimaryFunction_A41568"/>
          </xsl:call-template> | 
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="./BtnSideUpDownArrowButtonSecondaryFunction_A41592"/>
          </xsl:call-template>  
          <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        </xsl:if>
      </tr>
    </xsl:for-each>  
  </xsl:template>
  
  <xsl:template name="SMART_KEY_FOB_3000">
    <xsl:variable name="smart_key_fob" select="//SMARTKEYFOBBUTTONS/SET"/>
    <xsl:if test="count($smart_key_fob) > 0">
      <tr>
      <td class="sep" rowspan="{count($smart_key_fob)+2}">
          <xsl:value-of select="GUIRes:IncrementRowCount()"/>
        </td>
        <xsl:choose>
          <xsl:when test="$trunkingEnabled = 'true'">
            <th colspan="3">
              <xsl:call-template name="GUI_LOOK">
                <xsl:with-param name="lookup">ID_SMARTKEYFOBBUTTONS</xsl:with-param>
              </xsl:call-template>
            </th>
          </xsl:when>
          <xsl:otherwise>
            <th colspan="2">
              <xsl:call-template name="GUI_LOOK">
                <xsl:with-param name="lookup">ID_SMARTKEYFOBBUTTONS</xsl:with-param>
              </xsl:call-template>
            </th>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
    </xsl:if>
    <xsl:for-each select="$smart_key_fob">
      <tr>
        <xsl:choose>
          <xsl:when test="position() = last()">
            <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="./RadErgoCfgFobButtonName_A41573"/>
        </xsl:call-template>
        <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        <xsl:choose>
          <xsl:when test="position() = last()">
            <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="./RadErgoCfgFobConventionalFeature_A41574"/>
        </xsl:call-template>       
        <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        <xsl:if test="$trunkingEnabled = 'true'">
          <xsl:choose>
            <xsl:when test="position() = last()">
              <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="./RadErgoCfgFobTrunkingFeature_A41575"/>
          </xsl:call-template>
          <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        </xsl:if>
      </tr>
    </xsl:for-each>  
  </xsl:template>  

  <xsl:template name="PORTABLE_BUTTONS">
    <xsl:for-each select="//PORTABLEBUTTON/SET">
      <tr>
        <td class="sep">
          <xsl:value-of select="GUIRes:IncrementRowCount()"/>
        </td>
        <td class="sep">
          <xsl:call-template name ="GUI_RES">
            <xsl:with-param name="cp_node" select="./BtnPortableButtonName_A22558"/>
          </xsl:call-template>
        </td>
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="./BtnGeneralConventionalFeature_A19544"/>
          </xsl:call-template>
        </td>
        <xsl:if test="$trunkingEnabled = 'true'">
          <td class="sep">
            <xsl:call-template name="GUI_RES">
              <xsl:with-param name="cp_node" select="./BtnTrunkingPortableButtonFeature_A19546"/>
            </xsl:call-template>
          </td>
        </xsl:if>
      </tr>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
